<?php
/* --------------------------------------------------------------
  VpeReader.php 2021-11-03
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2021 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Deprecated\Vpe\App\Data;

use Doctrine\DBAL\Connection;

/**
 * Class VpeReader
 * @package    Gambio\Admin\Modules\Deprecated\Vpe\App\Data
 * @deprecated will be removed with the release of 4.7!
 */
class VpeReader
{
    /**
     * @var Connection
     */
    private $connection;
    
    
    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @param string $languageCode
     *
     * @return array
     */
    public function availableVpe(string $languageCode): array
    {
        $result = $this->connection->createQueryBuilder()
            ->select(implode(', ',
                             [
                                 'products_vpe_id AS "vpe_id"',
                                 'products_vpe_name AS unit_name'
                             ]))
            ->from('products_vpe', 'pv')
            ->innerJoin('pv', 'languages', 'l', 'l.languages_id=pv.language_id')
            ->where('l.code=:languageCode')
            ->setParameter('languageCode', $languageCode)
            ->groupBy(implode(', ', ['products_vpe_id', 'products_vpe_name']))
            ->execute()
            ->fetchAll();
        
        return array_map(static function (array $row): array {
            $row['vpe_id'] = (int)$row['vpe_id'];
            
            return $row;
        }, $result);
    }
    
    
    /**
     * @param int $productId
     *
     * @return array
     */
    public function productVpeData(int $productId): array
    {
        $columns = 'products_attributes_id, products_vpe_id, gm_vpe_value';
        $result  = $this->connection->createQueryBuilder()
            ->select($columns)
            ->from('products_attributes')
            ->where('products_id=:products_id')
            ->setParameter('products_id', $productId)
            ->groupBy($columns)
            ->orderBy('products_attributes_id')
            ->execute()
            ->fetchAll();
        
        return array_map(static function (array $row): array {
            return [
                'product_option_id' => (int)$row['products_attributes_id'],
                'vpe_id'            => (int)$row['products_vpe_id'],
                'vpe_value'         => (float)$row['gm_vpe_value']
            ];
        }, $result);
    }
}